/*
 * Copyright (C) 2001-2004 the xine-project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * $Id: lirc.c,v 1.5 2004/11/10 01:29:12 dsalt Exp $
 *
 * lirc (infrared control) code based on oxine
 */

#include "globals.h"
#include "defs.h"

#include <string.h>
#include <pthread.h>
#include <stdlib.h>
#include <stdio.h>

#include <glib.h>
#include <gtk/gtk.h>

#ifdef HAVE_LIRC
#include <lirc/lirc_client.h>
#endif

#include "engine.h"

static pthread_t             lirc_thread;
static struct lirc_config   *lircconfig;
static int                   lirc_fd;

/* lirc thread
  config file for lirc is ~/.gxine/lircrc
  prog name = gxine
  possible config are: (up, down, left, right, select, menu)
*/

#ifdef HAVE_LIRC
static void *lirc_run (void *data) {

  char  *code, *config;
  int    ret;
  gchar *fname;

  if ((lirc_fd = lirc_init ("gxine", 0)) == -1) {
    printf
      (_("lirc: lirc_init failed. Make sure that you have lircd running\n"
	 "lirc: and that you have the permissions to connect to the socket\n"));
    pthread_exit(NULL);
    return NULL;
  }

  fname = g_strconcat (g_get_home_dir(), "/.gxine/lircrc", NULL);

  if (lirc_readconfig (fname, &lircconfig, NULL) != 0) {

    /*printf("lirc: lirc_readconfig of %s failed\n", fname);*/
    pthread_exit (NULL);
    return NULL;
  }

  while(1) {
    
    pthread_testcancel();
    
    while (lirc_nextcode (&code) == 0) {

      pthread_testcancel();

      if (code == NULL) 
	break;
      
      while ((ret = lirc_code2char (lircconfig, code, &config) == 0) 
	     && (config != NULL)) {

	logprintf ("lirc: got command '%s'\n", config);

	gdk_threads_enter();
	engine_exec (config, NULL, NULL);
	gdk_threads_leave();

      }
      pthread_testcancel();
      
      free(code);

      if(ret == -1) 
	break;
    }
  }

  pthread_exit(NULL);
  return NULL;
}
#endif /* HAVE_LIRC */

void gxine_lirc_init (void) {

#ifdef HAVE_LIRC
  pthread_create (&lirc_thread, NULL, lirc_run, NULL);
#endif
  
}

void gxine_lirc_quit (void) {
#ifdef HAVE_LIRC
  pthread_cancel (lirc_thread);
#endif
}
