// Copyright (C) 2016 the V8 project authors. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
es6id: 24.2.2.1
esid: sec-dataview-buffer-byteoffset-bytelength
description: >
  Return abrupt from ToNumber(symbol byteOffset)
info: |
  24.2.2.1 DataView (buffer, byteOffset, byteLength )

  ...
  4. Let numberOffset be ? ToNumber(byteOffset).
  ...
features: [Symbol]
---*/

var s = Symbol("1");
var ab = new ArrayBuffer(0);

assert.throws(TypeError, function() {
  new DataView(ab, s);
});

reportCompare(0, 0);
