
/*
 * Copyright (C) 2002 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_callbacks.h"
#include "glade_gui.h"
#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "settings.h"
#include "misc.h"
#include "widgets.h"
#include "icons.h"

static gboolean disable_column_action=FALSE;
extern preferences_t opt_col_titles[];

void apply_view(GtkTreeView * treeview)
{
    tree_details_t *tree_details = get_tree_details(treeview);
    gtk_tree_view_column_set_visible(tree_details->column[SIZE_COL], 
		    tree_details->preferences & SHOW_SIZE);
    gtk_tree_view_column_set_visible(tree_details->column[DATE_COL], 
		    tree_details->preferences & SHOW_DATE);
    gtk_tree_view_column_set_visible(tree_details->column[UID_COL], 
		    tree_details->preferences & SHOW_UID);
    gtk_tree_view_column_set_visible(tree_details->column[GID_COL], 
		    tree_details->preferences & SHOW_GID);
    gtk_tree_view_column_set_visible(tree_details->column[MODE_COL], 
		    tree_details->preferences & SHOW_MODE);
    gtk_tree_view_set_headers_visible(treeview, 
		    tree_details->preferences & SHOW_TITLES);
    disable_column_action=TRUE;
    {
      int i;
      for (i=0;opt_col_titles[i].label;i++){
        GtkWidget *w = lookup_widget(tree_details->window, 
			opt_col_titles[i].xml_option);
	if(tree_details->preferences & opt_col_titles[i].flag)
	    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(w), TRUE);
	else 
	    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(w), FALSE);
      }
    }
    hide_bars(treeview);
    disable_column_action=FALSE;

}



void apply_preferences(GtkTreeView * treeview, int preferences)
{
    tree_details_t *tree_details = get_tree_details(treeview);
    tree_details->preferences = preferences;
}

void quick_hide(GtkButton * button, gpointer user_data)
{
    GtkTreeView *treeview = (GtkTreeView *) lookup_widget((GtkWidget *) button,
		    "treeview");
    tree_details_t *tree_details = get_tree_details(treeview);
    unsigned l = (unsigned)((long)user_data);
    GtkWidget *w=NULL;

    switch (l)
    {
	case SHOW_MM:
	    w = lookup_widget((GtkWidget *) button, "SHOW_MM");
	    break;
	case SHOW_TB1:
	    w = lookup_widget((GtkWidget *) button, "SHOW_TB1");
	    break;
	case SHOW_TB2:
	    w = lookup_widget((GtkWidget *) button, "SHOW_TB2");
	    break;
	case SHOW_F:
	    w = lookup_widget((GtkWidget *) button, "SHOW_F");
	    break;
	case SHOW_TITLES:
	    w = lookup_widget((GtkWidget *) button, "SHOW_TITLES");
	    break;
    }


    /* this should generate the signal for the appropriate callback */
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(w), !(tree_details->preferences & l));
    write_local_xffm_config (&tree_details); 
}

static gboolean set_subsort(GtkTreeModel * treemodel, 
		GtkTreePath * treepath, 
		GtkTreeIter * iter, 
		gpointer data)
{
    tree_entry_t *en;
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if (en) SET_TYPE_SUBSORT(en->type);
    return FALSE;
}

static gboolean unset_subsort(GtkTreeModel * treemodel, 
		GtkTreePath * treepath, 
		GtkTreeIter * iter, 
		gpointer data)
{
    tree_entry_t *en;
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if (en) UNSET_TYPE_SUBSORT(en->type);
    return FALSE;
}

static gboolean set_dot(GtkTreeModel * treemodel, 
		GtkTreePath * treepath, 
		GtkTreeIter * iter, 
		gpointer data)
{
    tree_entry_t *en;
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if (en) SET_SHOWS_HIDDEN(en->type);
    return FALSE;
}
static gboolean unset_dot(GtkTreeModel * treemodel, 
		GtkTreePath * treepath, 
		GtkTreeIter * iter, 
		gpointer data)
{
    tree_entry_t *en;
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if (en) UNSET_SHOWS_HIDDEN(en->type);
    return FALSE;
}

typedef struct change_size_t {
	GtkTreeView *treeview;
	int size;
}change_size_t;
static gboolean set_icon_size(GtkTreeModel * treemodel, 
		GtkTreePath * treepath, 
		GtkTreeIter * iter, 
		gpointer data)
{
    tree_entry_t *en;
    change_size_t *cs=(change_size_t *)data;
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if (en) switch(cs->size){
	    case 0: SET_SIZE_S(en->type); break;
	    case 1: SET_SIZE_M(en->type); break;
	    case 2: SET_SIZE_L(en->type); break;
	    case 3: SET_SIZE_XL(en->type); break;
    }
    set_icon(cs->treeview, iter);
    return FALSE;
}


void toggle_preference(GtkMenuItem * menuitem, gpointer user_data)
{
    /* always applies to treeview 1: */
    GtkTreeView *treeview = (GtkTreeView *)lookup_widget((GtkWidget *) menuitem,"treeview");
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    tree_details_t *tree_details = get_tree_details(treeview);
    change_size_t cs;
    unsigned flag = (unsigned)((long)user_data);
    if (disable_column_action) return;
    if (flag &(ICON_VIEW|DEFAULT_VIEW|SMALL_VIEW|DETAILED_VIEW)){
	    cs.treeview=treeview;
	    tree_details->preferences &= 
		 (BIT_MASK^(ICON_VIEW|DEFAULT_VIEW|SMALL_VIEW|DETAILED_VIEW));
	    tree_details->preferences &= 
		 (BIT_MASK^(SHOW_SIZE|SHOW_DATE|SHOW_UID|SHOW_GID|SHOW_MODE)); 
	    switch(flag){
		    case DETAILED_VIEW:
			   tree_details->preferences |= SHOW_UID; 
			   tree_details->preferences |= SHOW_GID; 
			   tree_details->preferences |= SHOW_MODE; 
		    case SMALL_VIEW:
			   tree_details->preferences |= SHOW_SIZE; 
		    case DEFAULT_VIEW:
			   tree_details->preferences |= SHOW_DATE; 
		    case ICON_VIEW:
			   break;
	    }
	    switch(flag){
		    case DETAILED_VIEW:
			    tree_details->icon_size=cs.size=0;
			break;
		    case SMALL_VIEW:
			    tree_details->icon_size=cs.size=1;
			break;
		    case DEFAULT_VIEW:
			    tree_details->icon_size=cs.size=2;
			break;
		    case ICON_VIEW:
			    tree_details->icon_size=cs.size=3;
			break;
	    }
	    gtk_tree_model_foreach(treemodel,set_icon_size, &cs);
    }
    else tree_details->preferences ^= flag;

    if (flag & FILETYPE_SUBS){
	gtk_tree_model_foreach(treemodel, 
			tree_details->preferences & FILETYPE_SUBS ?
		        set_subsort:unset_subsort, treeview);
    }
    if (flag & SHOW_DOT){
	gtk_tree_model_foreach(treemodel, 
			tree_details->preferences & SHOW_DOT ?
		        set_dot:unset_dot, treeview);
    }    
    if(flag & (IMAGE_PREVIEW | 
	       HIDE_WASTE_B | FILETYPE_SUBS | SHOW_DOT))
    {
	on_unselect_activate(menuitem, NULL);
	on_refresh((GtkButton *) menuitem, user_data);
    }
    if(flag & VIEW_MASK)
	apply_view(treeview);
    write_local_xffm_config (&tree_details); 

}

void
tb_toggleview                          (GtkButton       *button,
                                        gpointer         user_data)
{
    gboolean sub=(gboolean)((long)user_data);	
    GtkTreeView *treeview = get_treeview((GtkWidget *) button);
    tree_details_t *tree_details = get_tree_details(treeview);
  if (sub) tree_details->icon_size--;
  else tree_details->icon_size++;
  if (tree_details->icon_size>3) tree_details->icon_size=0;
  if (tree_details->icon_size<0) tree_details->icon_size=3;
  switch (tree_details->icon_size) {
	  case 0: toggle_preference((GtkMenuItem *)button,
				 (gpointer)((long)DETAILED_VIEW));
		  break;
	  case 1: toggle_preference((GtkMenuItem *)button,
				 (gpointer)((long)SMALL_VIEW));
		  break;
	  case 2: toggle_preference((GtkMenuItem *)button,
				 (gpointer)((long)DEFAULT_VIEW));
		  break;
	  case 3: toggle_preference((GtkMenuItem *)button,
				 (gpointer)((long)ICON_VIEW));
		  break;
  }
  write_local_xffm_config(&tree_details);
}



void on_save_preferences_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    GtkTreeView *treeview = get_treeview((GtkWidget *) menuitem);
    tree_details_t *tree_details = get_tree_details(treeview);
    write_local_xffm_config(&tree_details);
    /* this is for the xfce-mcs-manager: */
    write_xffm_config(&tree_details);
}

void toggle_theme(GtkMenuItem * menuitem, gpointer user_data)
{
    GtkTreeView *treeview = get_treeview((GtkWidget *) menuitem);
    tree_details_t *tree_details = get_tree_details(treeview);
    if(!tree_details) return;
    g_free(tree_details->theme);
    tree_details->theme=g_strdup((gchar *)user_data);
    recreate_icons(tree_details);
    write_local_xffm_config(&tree_details);
}
