/*
 * Copyright (c) 1996 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <signal.h>

/* OpenBSD */
#if defined(__OpenBSD__) && !defined(ENOTSUP)
#define ENOTSUP EOPNOTSUPP
#endif

#if !defined(HAVE_PSELECT) || defined(__OpenBSD__)
extern int pselect(int, fd_set *, fd_set *, fd_set *, const struct timespec *,
                   const sigset_t *);
#endif

#ifndef HAVE_STRNLEN
extern size_t strnlen(const char *s, size_t n);
#endif

#ifndef HAVE_STRLCPY
extern size_t strlcpy(char *, const char *, size_t);
#endif

#ifndef HAVE_STRLCAT
extern size_t strlcat(char *, const char *, size_t);
#endif

#ifndef HAVE_VASPRINTF
#include <stdio.h>
#include <stdarg.h>
extern int vasprintf(char **ret, const char *fmt, va_list ap);
#endif

/* Secure memory clearing - prefer memset_explicit (C23) over explicit_bzero */
#if !defined(HAVE_MEMSET_EXPLICIT) && !defined(HAVE_EXPLICIT_BZERO)
#include <stddef.h>
extern void explicit_bzero(void *s, size_t n);
#elif defined(HAVE_MEMSET_EXPLICIT) && !defined(HAVE_EXPLICIT_BZERO)
#include <string.h>
#define explicit_bzero(s, n) memset_explicit((s), 0, (n))
#endif
