/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.pilotlink;

import java.io.IOException;
import org.gnu.pilotlink.DBInfo;
import org.gnu.pilotlink.PilotLinkException;
import org.gnu.pilotlink.RawAppInfo;
import org.gnu.pilotlink.RawRecord;
import org.gnu.pilotlink.Record;
import org.gnu.pilotlink.SysInfo;
import org.gnu.pilotlink.User;
import org.gnu.pilotlink.Version;

public class PilotLink {
    private int handle;

    public boolean isConnected() {
        return this.handle >= 0;
    }

    public PilotLink(String string) throws IOException, PilotLinkException {
        System.out.println("Initialising Pilot-Link-Java-Bindings V" + Version.VERSION + " build #" + Version.BUILD);
        this.handle = this.connect(string);
    }

    private native int connect(String var1) throws IOException, PilotLinkException;

    public SysInfo getSysInfo() throws PilotLinkException {
        SysInfo sysInfo = this.readSysInfo(this.handle);
        return sysInfo;
    }

    private native SysInfo readSysInfo(int var1) throws PilotLinkException;

    public User getUserInfo() throws PilotLinkException {
        User user = this.readUserInfo(this.handle);
        return user;
    }

    private native User readUserInfo(int var1) throws PilotLinkException;

    public RawAppInfo getAppInfo(int n) throws PilotLinkException {
        return this.readAppInfo(this.handle, n);
    }

    private native RawAppInfo readAppInfo(int var1, int var2) throws PilotLinkException;

    public RawAppInfo getAppInfoBlock(String string) {
        return this.getAppInfoBlock(this.handle, string);
    }

    private native RawAppInfo getAppInfoBlock(int var1, String var2);

    public void writeUserInfo(User user) throws PilotLinkException {
        this.writeUserInfo(this.handle, user);
    }

    private native void writeUserInfo(int var1, User var2) throws PilotLinkException;

    private long toLong(char[] cArray) {
        int n = cArray.length;
        long l = 0L;
        for (int i = 0; i < n - 1; ++i) {
            l |= (long)cArray[i];
            l <<= 8;
        }
        return l |= (long)cArray[n - 1];
    }

    public int createDB(String string, String string2, String string3) throws PilotLinkException {
        long l = this.toLong(string2.toCharArray());
        long l2 = this.toLong(string3.toCharArray());
        return this.createDB(this.handle, l, string, l2, 0, 1);
    }

    public int createDB(String string, String string2, String string3, int n, int n2) throws PilotLinkException {
        long l = this.toLong(string2.toCharArray());
        long l2 = this.toLong(string3.toCharArray());
        return this.createDB(this.handle, l, string, l2, n, n2);
    }

    private native int createDB(int var1, long var2, String var4, long var5) throws PilotLinkException;

    private native int createDB(int var1, long var2, String var4, long var5, int var7, int var8) throws PilotLinkException;

    public int deleteDB(String string) throws PilotLinkException {
        return this.deleteDB(this.handle, string);
    }

    private native int deleteDB(int var1, String var2) throws PilotLinkException;

    public int openDB(String string) throws PilotLinkException {
        return this.openDB(this.handle, string);
    }

    private native int openDB(int var1, String var2) throws PilotLinkException;

    public int writeAppBlock(byte[] byArray, int n) throws PilotLinkException {
        return this.writeAppBlock(this.handle, n, byArray, byArray.length);
    }

    private native int writeAppBlock(int var1, int var2, byte[] var3, int var4) throws PilotLinkException;

    public int getRecordCount(int n) throws PilotLinkException {
        return this.getRecordCount(this.handle, n);
    }

    private native int getRecordCount(int var1, int var2) throws PilotLinkException;

    public Record getRecordByIndex(int n, int n2) throws PilotLinkException {
        return this.getRecordByIndex(this.handle, n, n2);
    }

    private native RawRecord getRecordByIndex(int var1, int var2, int var3) throws PilotLinkException;

    public void deleteRecordById(int n, long l) {
        this.deleteRecordById(this.handle, n, l);
    }

    private native int deleteRecordById(int var1, int var2, long var3);

    public boolean writeRecord(int n, Record record) throws PilotLinkException {
        return this.writeRecord(this.handle, n, record) > 0;
    }

    private native int writeRecord(int var1, int var2, Record var3) throws PilotLinkException;

    public int writeNewRecord(int n, Record record) throws PilotLinkException {
        return this.writeRecord(this.handle, n, record);
    }

    public void closeDB(int n) throws PilotLinkException {
        this.closeDB(this.handle, n);
        n = 0;
    }

    private native void closeDB(int var1, int var2) throws PilotLinkException;

    public void endSync() throws PilotLinkException {
        this.endSync(this.handle);
    }

    private native void endSync(int var1) throws PilotLinkException;

    public void close() {
        this.close(this.handle);
        this.handle = 0;
    }

    private native void close(int var1);

    public void openConduit() throws PilotLinkException {
        this.openConduit(this.handle);
    }

    private native void openConduit(int var1) throws PilotLinkException;

    private native RawRecord getResourceByIndex(int var1, int var2, int var3) throws PilotLinkException;

    private native void writeResource(int var1, int var2, RawRecord var3) throws PilotLinkException;

    private native void resetSystem(int var1) throws PilotLinkException;

    private native DBInfo readDBList(int var1, int var2, int var3, int var4) throws PilotLinkException;

    public RawRecord getResourceByIndex(int n, int n2) throws PilotLinkException {
        return this.getResourceByIndex(this.handle, n, n2);
    }

    public void writeResource(int n, RawRecord rawRecord) throws PilotLinkException {
        this.writeResource(this.handle, n, rawRecord);
    }

    public void resetSystem() throws PilotLinkException {
        this.resetSystem(this.handle);
    }

    public DBInfo readDBList(int n, int n2, int n3) throws PilotLinkException {
        return this.readDBList(this.handle, n, n2, n3);
    }

    static {
        System.loadLibrary("jpisock");
    }
}

